/* - Bridge full -
 * This example demonstrates the basic usage of a Phidget Bridge.  It
 * demonstrates the manipulation of the enabled state, gain, bridge value, data rate,
 * as well as displays the data from generated events.
 *
 * Please note that this example was designed to work with only one Phidget
 * Bridge connected.
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License.
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package Bridge;

import com.phidgets.BridgePhidget;
import com.phidgets.PhidgetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import listeners.BAttachListener;
import listeners.BDetachListener;
import listeners.BErrorListener;
import listeners.BBridgeDataListener;

public class Bridge extends javax.swing.JFrame {

    private static String runArgs[];
    private BridgePhidget bridge;
    private Hashtable gainHashTable;
    private BAttachListener attach_listener;
    private BDetachListener detach_listener;
    private BErrorListener error_listener;
    private BBridgeDataListener bridgeData_listener;

    public Bridge() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        attachedTxt = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        nameTxt = new javax.swing.JTextArea();
        jLabel2 = new javax.swing.JLabel();
        serialTxt = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        versionTxt = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        numBridgesTxt = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        bridgeDataPanel = new javax.swing.JPanel();
        jLabel6 = new javax.swing.JLabel();
        bridgeCmb = new javax.swing.JComboBox();
        enableChk = new javax.swing.JCheckBox();
        jLabel7 = new javax.swing.JLabel();
        gainCmb = new javax.swing.JComboBox();
        jLabel8 = new javax.swing.JLabel();
        bridgeValueTxt = new javax.swing.JTextField();
        jLabel10 = new javax.swing.JLabel();
        dataRateSld = new javax.swing.JSlider();
        dataRateTxt = new javax.swing.JTextField();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Bridge-full");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
        });
        getContentPane().setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Bridge Info"));
        jPanel1.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        attachedTxt.setEditable(false);
        jPanel1.add(attachedTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 33, 200, -1));

        jLabel1.setText("Attached:");
        jPanel1.add(jLabel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(43, 36, -1, -1));

        nameTxt.setBackground(javax.swing.UIManager.getDefaults().getColor("TextField.disabledBackground"));
        nameTxt.setColumns(20);
        nameTxt.setEditable(false);
        nameTxt.setLineWrap(true);
        nameTxt.setRows(3);
        nameTxt.setTabSize(2);
        nameTxt.setWrapStyleWord(true);
        nameTxt.setPreferredSize(new java.awt.Dimension(200, 58));
        jScrollPane1.setViewportView(nameTxt);

        jPanel1.add(jScrollPane1, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 68, 200, -1));

        jLabel2.setText("Name:");
        jPanel1.add(jLabel2, new org.netbeans.lib.awtextra.AbsoluteConstraints(60, 68, -1, -1));

        serialTxt.setEditable(false);
        jPanel1.add(serialTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 144, 200, -1));

        jLabel3.setText("Serial No:");
        jPanel1.add(jLabel3, new org.netbeans.lib.awtextra.AbsoluteConstraints(41, 147, -1, -1));

        versionTxt.setEditable(false);
        jPanel1.add(versionTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 180, 200, -1));

        jLabel4.setText("Version:");
        jPanel1.add(jLabel4, new org.netbeans.lib.awtextra.AbsoluteConstraints(48, 180, -1, -1));

        numBridgesTxt.setEditable(false);
        jPanel1.add(numBridgesTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 216, 200, -1));

        jLabel5.setText("# Bridges:");
        jPanel1.add(jLabel5, new org.netbeans.lib.awtextra.AbsoluteConstraints(36, 220, -1, 20));

        getContentPane().add(jPanel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 0, 320, 252));

        bridgeDataPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Bridge Data"));

        jLabel6.setText("Choose Bridge:");

        bridgeCmb.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bridgeCmbActionPerformed(evt);
            }
        });

        enableChk.setText("Enabled");
        enableChk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                enableChkActionPerformed(evt);
            }
        });

        jLabel7.setText("Gain:");

        gainCmb.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                gainCmbActionPerformed(evt);
            }
        });

        jLabel8.setText("Bridge Value(mV/V):");

        bridgeValueTxt.setEditable(false);

        jLabel10.setText("Data Rate:");

        dataRateSld.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                dataRateSldStateChanged(evt);
            }
        });

        dataRateTxt.setEditable(false);

        javax.swing.GroupLayout bridgeDataPanelLayout = new javax.swing.GroupLayout(bridgeDataPanel);
        bridgeDataPanel.setLayout(bridgeDataPanelLayout);
        bridgeDataPanelLayout.setHorizontalGroup(
            bridgeDataPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(bridgeDataPanelLayout.createSequentialGroup()
                .addGroup(bridgeDataPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(bridgeDataPanelLayout.createSequentialGroup()
                        .addGap(42, 42, 42)
                        .addComponent(jLabel10)
                        .addGap(7, 7, 7)
                        .addComponent(dataRateSld, javax.swing.GroupLayout.PREFERRED_SIZE, 130, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(10, 10, 10)
                        .addComponent(dataRateTxt, javax.swing.GroupLayout.PREFERRED_SIZE, 40, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(bridgeDataPanelLayout.createSequentialGroup()
                        .addGap(42, 42, 42)
                        .addGroup(bridgeDataPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(bridgeDataPanelLayout.createSequentialGroup()
                                .addComponent(enableChk)
                                .addGap(0, 0, 0)
                                .addGroup(bridgeDataPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(bridgeDataPanelLayout.createSequentialGroup()
                                        .addGap(19, 19, 19)
                                        .addComponent(jLabel8))
                                    .addComponent(jLabel7))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(bridgeValueTxt, javax.swing.GroupLayout.DEFAULT_SIZE, 59, Short.MAX_VALUE))
                            .addComponent(jLabel6)))
                    .addGroup(bridgeDataPanelLayout.createSequentialGroup()
                        .addGap(86, 86, 86)
                        .addGroup(bridgeDataPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                            .addComponent(bridgeCmb, javax.swing.GroupLayout.Alignment.LEADING, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(gainCmb, javax.swing.GroupLayout.Alignment.LEADING, 0, 177, Short.MAX_VALUE))))
                .addGap(22, 22, 22))
        );
        bridgeDataPanelLayout.setVerticalGroup(
            bridgeDataPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(bridgeDataPanelLayout.createSequentialGroup()
                .addGroup(bridgeDataPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(bridgeDataPanelLayout.createSequentialGroup()
                        .addGap(14, 14, 14)
                        .addComponent(jLabel6)
                        .addGap(11, 11, 11)
                        .addComponent(gainCmb, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(bridgeDataPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(bridgeDataPanelLayout.createSequentialGroup()
                                .addGroup(bridgeDataPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(bridgeDataPanelLayout.createSequentialGroup()
                                        .addComponent(enableChk)
                                        .addGap(4, 4, 4)
                                        .addComponent(jLabel8))
                                    .addComponent(bridgeValueTxt, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addGap(16, 16, 16)
                                .addGroup(bridgeDataPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(bridgeDataPanelLayout.createSequentialGroup()
                                        .addGap(6, 6, 6)
                                        .addComponent(jLabel10))
                                    .addComponent(dataRateSld, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(dataRateTxt, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                            .addGroup(bridgeDataPanelLayout.createSequentialGroup()
                                .addGap(17, 17, 17)
                                .addComponent(jLabel7))))
                    .addGroup(bridgeDataPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(bridgeCmb, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        getContentPane().add(bridgeDataPanel, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 255, 320, 180));

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened
        this.setSize(357, 295);

        attachedTxt.setText("false");
        bridgeDataPanel.setVisible(false);
        bridgeDataPanel.setEnabled(false);

        bridgeCmb.setVisible(false);
        bridgeCmb.setEnabled(false);
        gainCmb.setVisible(false);
        gainCmb.setEnabled(false);

        gainHashTable = new Hashtable();

        gainHashTable.put(1, BridgePhidget.PHIDGET_BRIDGE_GAIN_1);
        gainHashTable.put(8, BridgePhidget.PHIDGET_BRIDGE_GAIN_8);
        gainHashTable.put(16, BridgePhidget.PHIDGET_BRIDGE_GAIN_16);
        gainHashTable.put(32, BridgePhidget.PHIDGET_BRIDGE_GAIN_32);
        gainHashTable.put(64, BridgePhidget.PHIDGET_BRIDGE_GAIN_64);
        gainHashTable.put(128, BridgePhidget.PHIDGET_BRIDGE_GAIN_128);

        enableChk.setVisible(false);
        enableChk.setEnabled(false);

        bridgeValueTxt.setVisible(false);
        bridgeValueTxt.setEnabled(false);

        dataRateTxt.setVisible(false);
        dataRateTxt.setEnabled(false);
        dataRateSld.setVisible(false);
        dataRateSld.setEnabled(false);

        try {
            bridge = new BridgePhidget();

            attach_listener = new BAttachListener(this, this.bridgeDataPanel, this.bridgeCmb, this.gainCmb, this.gainHashTable, this.attachedTxt, this.nameTxt,
                    this.serialTxt, this.versionTxt, this.numBridgesTxt, this.enableChk, this.bridgeValueTxt, this.dataRateSld, this.dataRateTxt);

            detach_listener = new BDetachListener(this, this.bridgeDataPanel, this.bridgeCmb, this.gainCmb, this.attachedTxt, this.nameTxt,
                    this.serialTxt, this.versionTxt, this.numBridgesTxt, this.enableChk, this.bridgeValueTxt, this.dataRateSld, this.dataRateTxt);

            error_listener = new BErrorListener(this);

            bridgeData_listener = new BBridgeDataListener(this.bridgeCmb, this.bridgeValueTxt);

            bridge.addAttachListener(attach_listener);
            bridge.addDetachListener(detach_listener);
            bridge.addErrorListener(error_listener);
            bridge.addBridgeDataListener(bridgeData_listener);

            //This assumes that if there is a command line argument, it is a serial number
            //and we try to open that specific device. Otherwise, open any device.
            if ((runArgs.length > 1) && (runArgs[1].equals("remote"))) {
                bridge.open(Integer.parseInt(runArgs[0]), null);
            }
            if (runArgs.length > 0) {
                bridge.open(Integer.parseInt(runArgs[0]));
            } else {
                bridge.openAny();
            }

        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_formWindowOpened

    private void enableChkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_enableChkActionPerformed
        int index = ((Integer) bridgeCmb.getSelectedItem()).intValue();
        try {
            bridge.setEnabled(((Integer) bridgeCmb.getSelectedItem()).intValue(), enableChk.isSelected());
            try {
                Thread.sleep(80); //allow device time to set enabled state to false
            } catch (InterruptedException ex) {
            }
            if (enableChk.isSelected()) {
                bridgeValueTxt.setEnabled(true);
                gainCmb.setEnabled(true);
                setGainCmb();

                dataRateSld.setEnabled(true);
                dataRateTxt.setText(Integer.toString(bridge.getDataRate()));
            } else {
                bridgeValueTxt.setText("");
                gainCmb.setEnabled(false);
                dataRateSld.setEnabled(false);
                dataRateTxt.setText("");
            }
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }

    }//GEN-LAST:event_enableChkActionPerformed

    private void gainCmbActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_gainCmbActionPerformed
        bridgeValueTxt.setText("");
        int index = ((Integer) bridgeCmb.getSelectedItem()).intValue();
        try {
            if (bridge.isAttached() && bridge.getEnabled(index)) {
                int value = ((Integer) (gainHashTable.get(gainCmb.getSelectedItem())));
                bridge.setGain(index, value);
            }
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_gainCmbActionPerformed

    private void dataRateSldStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_dataRateSldStateChanged
        if (dataRateSld.isEnabled()) {
            try {
                bridge.setDataRate(dataRateSld.getValue() * 8);
                dataRateTxt.setText(Integer.toString(dataRateSld.getValue() * 8));
            } catch (PhidgetException ex) {
            }
        }
    }//GEN-LAST:event_dataRateSldStateChanged

    private void bridgeCmbActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bridgeCmbActionPerformed
        bridgeValueTxt.setText("");

        int index = ((Integer) bridgeCmb.getSelectedItem()).intValue();

        try {
            if (bridge.isAttached() && bridge.getEnabled(index)) {
                enableChk.setSelected(true);
                gainCmb.setEnabled(true);
                dataRateSld.setEnabled(true);
                dataRateTxt.setText(Integer.toString(bridge.getDataRate()));

                setGainCmb();

            } else {
                enableChk.setSelected(false);
                gainCmb.setEnabled(false);
                dataRateSld.setEnabled(false);
                dataRateTxt.setText("");
            }
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_bridgeCmbActionPerformed

    private void setGainCmb() {
        int index = ((Integer) bridgeCmb.getSelectedItem()).intValue();
        Enumeration eKeys = gainHashTable.keys();
        int element;
        try {
            element = bridge.getGain(index);

            while (eKeys.hasMoreElements()) {
                Object currKey = eKeys.nextElement();
                if (((Integer) gainHashTable.get(currKey)).intValue() == element) {
                    gainCmb.setSelectedItem(currKey);
                }
            }
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        runArgs = args;
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                new Bridge().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField attachedTxt;
    private javax.swing.JComboBox bridgeCmb;
    private javax.swing.JPanel bridgeDataPanel;
    private javax.swing.JTextField bridgeValueTxt;
    private javax.swing.JSlider dataRateSld;
    private javax.swing.JTextField dataRateTxt;
    private javax.swing.JCheckBox enableChk;
    private javax.swing.JComboBox gainCmb;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea nameTxt;
    private javax.swing.JTextField numBridgesTxt;
    private javax.swing.JTextField serialTxt;
    private javax.swing.JTextField versionTxt;
    // End of variables declaration//GEN-END:variables
}
